<?php

/**
 * Alpha Adobe Fonts Addons
 *
 * @author     D-THEMES
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @since    4.15.0
 */
defined( 'ABSPATH' ) || die;

if ( ! class_exists( 'Alpha_Adobe_Fonts' ) ) {
	class Alpha_Adobe_Fonts extends Alpha_Base {

		/**
		 * Constructor
		 *
		 * @since 4.15.0
		 */
		public function __construct() {
			// Add theme options
			add_filter( 'alpha_customize_fields', array( $this, 'add_customize_fields' ) );

			// Merge with dynamic styles
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_styles' ), 25 );

			// Add custom fonts to kirki control
			add_filter( 'alpha_kirki_typo_control_choices', array( $this, 'add_kirki_font_params' ) );

			// Add custom fonts to elementor control
			add_filter( 'elementor/fonts/groups', array( $this, 'add_elementor_font_groups' ) );
			add_filter( 'elementor/fonts/additional_fonts', array( $this, 'add_elementor_font_params' ) );

		}

		/**
		 * Add fields for custom fonts
		 *
		 * @param {Array} $fields
		 *
		 * @since 4.15.0
		 */
		public function add_customize_fields( $fields ) {
			// Style / Adobe Fonts
			$fields['cs_typo_adobe_title'] = array(
				'section' => 'adobe_fonts',
				'type'    => 'custom',
				'default' => '<h3 class="options-custom-title">' . esc_html__( 'Adobe Fonts', 'alpha' ) . '</h3>',
			);
			$fields['cs_typo_adobe_alert'] = array(
				'section' => 'adobe_fonts',
				'type'    => 'custom',
				'label'   => sprintf( esc_html__( '%1$sTo use your Adobe font, you need to create an account %3$shere%4$s and obtain your key ID here. Then, you need to enter all custom fonts you will use separated with comma. After this, %5$spublish%6$s Theme Options and %5$sreload%6$s this page to be able to select your fonts in the list of typography control.%2$s', 'alpha-core' ), '<p style="margin: 0;">', '</p>', '<a href="https://fonts.adobe.com/" target="_blank">', '</a>', '<b>', '</b>' ),
			);
			$fields['adobe_ids']           = array(
				'section'   => 'adobe_fonts',
				'type'      => 'text',
				'label'     => esc_html__( 'Adobe Project IDs', 'alpha-core' ),
				'transport' => 'postMessage',
				'tooltip'   => esc_html__( 'Enter the Adobe Fonts (formerly TypeKit) Web Project IDs separate with comma.', 'alpha-core' ),
			);
			$fields['adobe_fonts']         = array(
				'section'   => 'adobe_fonts',
				'type'      => 'text',
				'label'     => esc_html__( 'Adobe Font Face', 'alpha-core' ),
				'transport' => 'postMessage',
				'tooltip'   => esc_html__( 'Separate with comma.', 'alpha-core' ),
			);

			return $fields;
		}

		/**
		 * Add options to kirki typography control
		 *
		 * @param {Array} $params
		 *
		 * @since 4.15.0
		 */
		public function add_kirki_font_params( $params ) {

			if ( ! function_exists( 'alpha_get_option' ) ) {
				return $params;
			}

			$adobe_fonts = alpha_get_option( 'adobe_fonts' );

			if ( $adobe_fonts ) {
				$typekit = explode( ',', str_replace( ' ', '', $adobe_fonts ) );

				if ( count( $typekit ) ) {
					$choices_map = array();
					foreach ( $typekit as $font ) {
						$choices_map[] = array(
							'id'   => $font,
							'text' => ucfirst( trim( $font ) ),
						);
					}

					if ( $choices_map ) {
						if ( empty( $params['fonts']['families'] ) ) {
							$params['fonts']['families'] = array();
						}
						$params['fonts']['families'] = array_merge(
							$params['fonts']['families'],
							array(
								'adobe' => array(
									'text'     => esc_html__( 'Adobe Fonts', 'alpha-core' ),
									'children' => $choices_map,
								),
							),
						);
					}
				}
			}

			return $params;
		}

		/**
		 * Add 'Custom' group to elementor typography control
		 *
		 * @param {Array} $groups
		 *
		 * @since 4.15.0
		 */
		public function add_elementor_font_groups( $groups ) {

			if ( ! function_exists( 'alpha_get_option' ) ) {
				return $groups;
			}

			$groups['alpha-adobe'] = esc_html__( 'Adobe', 'alpha-core' );
			return $groups;
		}

		/**
		 * Add options to elementor typography control
		 *
		 * @param {Array} $params
		 *
		 * @since 4.15.0
		 */
		public function add_elementor_font_params( $params ) {

			if ( ! function_exists( 'alpha_get_option' ) ) {
				return $params;
			}

			$adobe_fonts = alpha_get_option( 'adobe_fonts' );

			if ( $adobe_fonts ) {
				$typekit = explode( ',', str_replace( ' ', '', $adobe_fonts ) );

				if ( count( $typekit ) ) {
					foreach ( $typekit as $font ) {
						if ( isset( $font ) ) {
							$params[ ucfirst( trim( $font ) ) ] = 'alpha-adobe';
						}
					}
				}
			}

			return $params;
		}

		/**
		 * Merge font style with dynamic styles
		 *
		 * @param {String} $style
		 *
		 * @since 4.15.0
		 */
		public function enqueue_styles( $style ) {
			// load typekit fonts.
			$typekit_id = alpha_get_option( 'adobe_ids' );

			if ( $typekit_id ) {
				$project_ids = explode( ',', str_replace( ' ', '', $typekit_id ) );

				foreach ( $project_ids as $id ) {
					wp_enqueue_style( 'alpha-typekit-' . $id, 'https://use.typekit.net/' . esc_attr( $id ) . '.css', array(), ALPHA_CORE_VERSION );
				}
			}
		}
	}
	Alpha_Adobe_Fonts::get_instance();
}
