<?php
/**
 * Alpha Elementor Single Product Linked Products Widget
 *
 * @author     D-THEMES
 * @package    Alpha Core Framework
 * @subpackage Core
 * @since      1.0
 */
defined( 'ABSPATH' ) || die;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

class Alpha_Product_Linked_Products_Elementor_Widget extends Alpha_Posts_Grid_Elementor_Widget {

	public function get_name() {
		return ALPHA_NAME . '_widget_product_linked_products';
	}

	public function get_title() {
		global $post;
		if ( $post && ( is_cart() || 'cart' == get_post_meta( $post->ID, ALPHA_NAME . '_template_type', true ) ) ) {
			return esc_html__( 'Cross-sells Products', 'alpha-core' );
		}
		return esc_html__( 'Linked Products', 'alpha-core' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon eicon-product-related';
	}

	public function get_categories() {
		return array( 'alpha_single_product_widget', 'alpha_cart_widget' );
	}

	public function get_keywords() {
		return array( 'single', 'custom', 'layout', 'product', 'woocommerce', 'shop', 'store', 'linked_products', 'cart', 'cross', 'upsell', 'related' );
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	protected function register_controls() {
		global $post;

		$this->start_controls_section(
			'section_title',
			array(
				'label' => esc_html__( 'Title', 'alpha-core' ),
			),
		);

			$this->add_control(
				'show_title',
				array(
					'type'  => Controls_Manager::SWITCHER,
					'label' => esc_html__( 'Show Title', 'alpha-core' ),
				)
			);

			$this->add_control(
				'linked_title',
				array(
					'label'       => esc_html__( 'Title', 'alpha-core' ),
					'type'        => Controls_Manager::TEXT,
					'default'     => $post && ( is_cart() || 'cart' == get_post_meta( $post->ID, ALPHA_NAME . '_template_type', true ) ) ? esc_html__( 'Cross-sells Products', 'alpha-core' ) : esc_html__( 'Related Products', 'alpha-core' ),
					'description' => esc_html__( 'Title is hidden when posts result is empty.', 'alpha-core' ),
					'condition'   => array(
						'show_title' => 'yes',
					),
				)
			);

			$this->add_control(
				'title_align',
				array(
					'label'     => esc_html__( 'Alignment', 'alpha-core' ),
					'type'      => Controls_Manager::CHOOSE,
					'options'   => array(
						'start'  => array(
							'title' => esc_html__( 'Left', 'alpha-core' ),
							'icon'  => 'eicon-text-align-left',
						),
						'center' => array(
							'title' => esc_html__( 'Center', 'alpha-core' ),
							'icon'  => 'eicon-text-align-center',
						),
						'end'    => array(
							'title' => esc_html__( 'Right', 'alpha-core' ),
							'icon'  => 'eicon-text-align-right',
						),
					),
					'selectors' => array(
						'.elementor-element-{{ID}} .linked-title' => 'text-align: {{VALUE}}',
					),
					'condition' => array(
						'show_title' => 'yes',
					),
				)
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			array(
				'label'     => __( 'Title', 'alpha-core' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'show_title' => 'yes',
				),
			),
		);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'title_typo',
					'selector' => '.elementor-element-{{ID}} .linked-title',
				)
			);

			$this->add_control(
				'title_color',
				array(
					'label'     => esc_html__( 'Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .linked-title' => 'color: {{VALUE}}',
					),
				)
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				array(
					'name'     => 'title_border',
					'selector' => '.elementor-element-{{ID}} .linked-title',
				)
			);

			$this->add_responsive_control(
				'title_margin',
				array(
					'label'      => esc_html__( 'Margin', 'alpha-core' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array(
						'px',
						'%',
						'em',
						'rem',
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .linked-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

			$this->add_responsive_control(
				'title_padding',
				array(
					'label'      => esc_html__( 'Padding', 'alpha-core' ),
					'type'       => Controls_Manager::DIMENSIONS,
					'size_units' => array(
						'px',
						'%',
						'em',
						'rem',
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .linked-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					),
				)
			);

		$this->end_controls_section();

		parent::register_controls();

		$this->remove_control( 'source' );
		$this->update_control(
			'orderby',
			array(
				'type'        => Controls_Manager::SELECT,
				'label'       => esc_html__( 'Order by', 'alpha-core' ),
				'options'     => array(
					''               => esc_html__( 'Default', 'alpha-core' ),
					'ID'             => esc_html__( 'ID', 'alpha-core' ),
					'title'          => esc_html__( 'Name', 'alpha-core' ),
					'date'           => esc_html__( 'Date', 'alpha-core' ),
					'modified'       => esc_html__( 'Modified', 'alpha-core' ),
					'price'          => esc_html__( 'Price', 'alpha-core' ),
					'rand'           => esc_html__( 'Random', 'alpha-core' ),
					'rating'         => esc_html__( 'Rating', 'alpha-core' ),
					'comment_count'  => esc_html__( 'Comment count', 'alpha-core' ),
					'popularity'     => esc_html__( 'Total Sales', 'alpha-core' ),
					'wishqty'        => esc_html__( 'Wish', 'alpha-core' ),
					'sale_date_to'   => esc_html__( 'Sale End Date', 'alpha-core' ),
					'sale_date_from' => esc_html__( 'Sale Start Date', 'alpha-core' ),
				),
				'description' => esc_html__( 'Price, Rating, Total Sales, Wish, Sale End Date and Sale Start Date values work for only product post type.', 'alpha-core' ),
				'condition'   => array(),
			)
		);
		global $post;
		if ( ( $post && ( is_cart() || 'cart' == get_post_meta( $post->ID, ALPHA_NAME . '_template_type', true ) ) ) ) {
				$this->update_control(
					'post_type',
					array(
						'type'        => Controls_Manager::HIDDEN,
						'label'       => esc_html__( 'Product Source', 'alpha-core' ),
						'description' => esc_html__( 'Please select a product type of products to display related or upsell products', 'alpha-core' ),
						'default'     => 'crosssell',
						'options'     => array(
							'crosssell' => esc_html__( 'Cross-sells Products', 'alpha-core' ),
						),
						'condition'   => array(),
					)
				);
		} elseif ( alpha_is_product() || ( $post && 'product_layout' == get_post_meta( $post->ID, ALPHA_NAME . '_template_type', true ) ) ) {
			$this->update_control(
				'post_type',
				array(
					'type'        => Controls_Manager::SELECT,
					'label'       => esc_html__( 'Product Source', 'alpha-core' ),
					'description' => esc_html__( 'Please select a product type of products to display related or upsell products', 'alpha-core' ),
					'default'     => 'related',
					'options'     => array(
						'related' => esc_html__( 'Related Products', 'alpha-core' ),
						'upsell'  => esc_html__( 'Upsells Products', 'alpha-core' ),
					),
					'condition'   => array(),
				)
			);
		}

		$this->add_control(
			'linked_description',
			array(
				'raw'             => esc_html__( 'If there are no linked products, the widget will show products randomly.', 'alpha-core' ),
				'type'            => Controls_Manager::RAW_HTML,
				'content_classes' => 'alpha-notice notice-warning',
			),
			array(
				'position' => array(
					'at' => 'after',
					'of' => 'orderway',
				),
			)
		);

		$this->remove_control( 'post_tax' );
		$this->remove_control( 'post_filter_section' );
	}

	protected function render() {

		$atts = $this->get_settings_for_display();
		if ( is_array( $atts['count'] ) ) {
			if ( ! empty( $atts['count']['size'] ) ) {
				$atts['count'] = $atts['count']['size'];
			} else {
				$atts['count'] = '4';
			}
		}

		if ( is_array( $atts['col_cnt'] ) ) {
			if ( isset( $atts['col_cnt']['size'] ) ) {
				$atts['col_cnt'] = $atts['col_cnt']['size'];
			} else {
				$atts['col_cnt'] = '';
			}
		}
		global $post;
		if ( ( $post && ( is_cart() || 'cart' == get_post_meta( $post->ID, ALPHA_NAME . '_template_type', true ) ) ) ) {
			// Cart builder - only use cross-sells
			$atts['shortcode_type'] = 'cart';
			require alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/builders/single-product/widgets/linked-products/render-linked-products-elementor.php' );
		} elseif ( alpha_is_product() || ( $post && 'product_layout' == get_post_meta( $post->ID, ALPHA_NAME . '_template_type', true ) ) ) {
			/**
			 * Filters post products in single product builder
			 *
			 * @since 1.0
			 */
			apply_filters( 'alpha_single_product_builder_set_preview', false );
			require alpha_core_framework_path( ALPHA_CORE_FRAMEWORK_PATH . '/builders/single-product/widgets/linked-products/render-linked-products-elementor.php' );
			do_action( 'alpha_single_product_builder_unset_preview' );
		}
	}
}
