jQuery(document).ready(function ($) {
    themeAdmin.prompt.hideDialog();
    themeAdmin.prompt.showDialog({
        title: wp.i18n.__('Init Elementor Config', 'alpha-core'),
        content: wp.i18n.__('Do you want to initialize elementor configuration as ', 'alpha-core') + alpha_studio.texts.theme_display_name + wp.i18n.__(' supports?', 'alpha-core') + ' ' + wp.i18n.__('Elementor color & font styles will be inherit from our theme and custom breakpoints will be added.', 'alpha-core'),
        closeOnOverlay: false,
        customClass: 'el-config-notice',
        actions: [
            {
                title: wp.i18n.__('Yes', 'alpha-core'),
                callback: function () {
                    $.ajax({
                        type: 'POST',
                        url: alpha_core_vars.ajax_url,
                        data: {
                            init_config: 'yes',
                            action: 'alpha_init_elementor_config',
                        },
                        success: function (response) {
                            location.reload();
                        }
                    });
                }
            },
            {
                title: wp.i18n.__('No', 'alpha-core'),
                callback: function () {
                    $.ajax({
                        type: 'POST',
                        url: alpha_core_vars.ajax_url,
                        data: {
                            init_config: 'no',
                            action: 'alpha_init_elementor_config',
                        },
                        success: function (response) {
                        }
                    });
                }
            },
        ]
    });
});
