/**
 * Alpha Isotopes Js Library
 * 
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      4.14.0
 */
'use strict';

window.theme || (window.theme = {});

(function ($) {

    /**
     * Alpha Stretch Container
     * 
     * @since 1.0
     */
    theme.initStretchContainer = function (selector) {
        function stretchContainer() {
            $(selector).each(function () {
                var $this = $(this),
                    direction = $this.attr('data-stretch'),
                    minWidth = $this.attr('data-stretch-width');

                $this.css('width', '');
                $this.css('margin', '');

                var pos = $this.offset().left,
                    viewport = $(window).width(),
                    currentWidth = $this.outerWidth(),
                    value = viewport - (currentWidth + pos);

                if (viewport <= minWidth) {
                    return;
                }

                if (direction == 'left') {
                    value = pos;
                };

                $this.css('width', currentWidth + value + 'px');
                $this.css('margin-' + direction, '-' + value + 'px');
            });
        }

        stretchContainer();
        $(window).on('resize', stretchContainer)
    }

    if (window.theme && typeof theme.status == 'undefined') {
        theme.initStretchContainer('.e-con[data-stretch="left"], .e-con[data-stretch="right"]'); // Initialize Stretch Container
    } else {
        $(window).on('alpha_complete', function () {
            theme.initStretchContainer('.e-con[data-stretch="left"], .e-con[data-stretch="right"]'); // Initialize Stretch Container
        });
    }
})(jQuery);