/**
 * Alpha Elementor Preview
 * 
 * @author     Andon
 * @package    Alpha Core FrameWork
 * @subpackage Core
 * @since      1.0
 * 
 */
'use strict';

(function ($) {
    /**
     * Setup AlphaElementorPreview
     */
    $(window).on('elementor/frontend/init', function () {
        if (elementorFrontend && elementorModules.frontend && 'undefined' != typeof alpusFlexbox) {
            alpusFlexbox.SlidesHandler.prototype.getSpaceBetween = function () {
                let e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : null;
                let kitSpacing = elementorFrontend.utils.controls.getResponsiveControlValue(elementorFrontend.config.kit, "space_between_widgets", "column", e),
                    widgetSpacing = elementorFrontend.utils.controls.getResponsiveControlValue(this.getElementSettings(), "slide_spacing", "size", e);
                return '' !== widgetSpacing ? widgetSpacing : kitSpacing;
            }
            alpusFlexbox.SlidesHandler.prototype.getSwiperOptions = function () {
                const e = this.getElementSettings()
                    , t = e.slides_to_show ? e.slides_to_show : 1
                    , s = 1 === t
                    , i = elementorFrontend.config.responsive.activeBreakpoints
                    , n = {
                        mobile: 1,
                        tablet: s ? 1 : 2
                    }
                    , a = {
                        autoplay: this.getAutoplayConfig(),
                        grabCursor: false,
                        initialSlide: this.getInitialSlide(),
                        slidesPerView: t,
                        slidesPerGroup: 1,
                        parallax: "parallax" === e.transition,
                        loop: "yes" === e.infinite,
                        centeredSlides: "yes" === e.center_mode,
                        speed: e.transition_speed,
                        effect: e.transition,
                        observeParents: !0,
                        observer: !0,
                        handleElementorBreakpoints: !0,
                        watchSlidesProgress: true,
                        on: {
                            slideChange: () => {
                                this.handleKenBurns()
                            }
                        },
                        breakpoints: {}
                    };
                let o = t,
                    index = 0,
                    reverseBrk = Object.keys(i).reverse();

                let globalSpace = (typeof this.getSpaceBetween() != 'undefined' && '' !== this.getSpaceBetween()) ? parseInt(this.getSpaceBetween()) : '';

                reverseBrk.forEach((t => {
                    const s = n[t] ? n[t] : o;
                    var brkWidth = typeof reverseBrk[index + 1] == 'undefined' ? 0 : (i[reverseBrk[index + 1]].value + 1);
                    if (t == 'tablet' || t == 'mobile') {
                        a.breakpoints[brkWidth] = {
                            slidesPerView: +e["slides_to_show_" + t] || s,
                            slidesPerGroup: +e["slides_to_scroll_" + t] || 1
                        };
                    }
                    var spaceBetween = this.getSpaceBetween(t);
                    if (spaceBetween !== '' && typeof spaceBetween !== 'undefined') {
                        spaceBetween = parseInt(spaceBetween);
                        if (!index && globalSpace) {
                            var parentWidth = typeof reverseBrk[index] == 'undefined' ? 0 : (i[reverseBrk[index]].value + 1);
                            if (parentWidth) {
                                if (typeof a.breakpoints[parentWidth] == 'undefined') {
                                    if (parentWidth >= 1200) {
                                        a.breakpoints[parentWidth] = {
                                            slidesPerView: (typeof e.slides_to_show_xl != 'undefined' && e.slides_to_show_xl !== '') ? e.slides_to_show_xl : s,
                                            slidesPerGroup: e.slides_to_scroll || 1,
                                        };
                                    } else {
                                        a.breakpoints[parentWidth] = {};
                                    }
                                }
                                a.breakpoints[parentWidth].spaceBetween = globalSpace;
                            }
                        }
                        if (typeof a.breakpoints[brkWidth] == 'undefined') {
                            if (brkWidth >= 1200) {
                                a.breakpoints[brkWidth] = {
                                    slidesPerView: (typeof e.slides_to_show_xl != 'undefined' && e.slides_to_show_xl !== '') ? e.slides_to_show_xl : s,
                                    slidesPerGroup: e.slides_to_scroll || 1,
                                };
                            } else {
                                a.breakpoints[brkWidth] = {};
                            }
                        }
                        a.breakpoints[brkWidth].spaceBetween = spaceBetween;
                    }
                    o = +e["slides_to_show_" + t] || s
                    index++;
                }
                ))

                if (globalSpace !== '') {
                    a.spaceBetween = globalSpace;
                }

                if (e.slides_to_show_xl) {
                    a.breakpoints[1200] = typeof a.breakpoints[1200] != 'undefined' ? a.breakpoints[1200] : {};
                    a.breakpoints[1200].slidesPerView = e.slides_to_show_xl || t;
                    a.breakpoints[1200].slidesPerGroup = e.slides_to_scroll || 1;
                }

                a.breakpoints[992] = typeof a.breakpoints[992] != 'undefined' ? a.breakpoints[992] : {};
                a.breakpoints[992].slidesPerView = t;
                a.breakpoints[992].slidesPerGroup = e.slides_to_scroll || 1;

                if (e.slides_to_show_min) {
                    a.breakpoints[0] = typeof a.breakpoints[0] != 'undefined' ? a.breakpoints[0] : {};
                    a.breakpoints[576] = Object.assign({}, a.breakpoints[0]);
                    a.breakpoints[0].slidesPerView = e.slides_to_show_min || t;
                    a.breakpoints[0].slidesPerGroup = e["slides_to_scroll_mobile"] || 1;
                }
                a.handleElementorBreakpoints = false;
                const r = "arrows" === e.navigation || "both" === e.navigation
                    , l = "dots" === e.navigation || "both" === e.navigation;
                return r && (a.navigation = {
                    prevEl: ".elementor-swiper-button-prev",
                    nextEl: ".elementor-swiper-button-next"
                }),
                    e.autoheight && (a.autoHeight = 1),
                    e.disable_drag && (a.allowTouchMove = !1),
                    l && e.pagination && (a.pagination = {
                        el: ".swiper-pagination",
                        type: e.pagination,
                        clickable: !0,
                        renderBullet: e.dots_type == 'active_circle' ? function (index, className) {
                            return '<span class="' + className + '"><svg width="70px" height="70px" viewBox="0 0 70 70" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"><circle class="time" stroke-width="5" fill="none" stroke-linecap="round" cx="35" cy="35" r="28"></circle></svg></span>';
                        } : null
                    },
                        "dynamic" == e.pagination && (a.pagination.dynamicBullets = !0,
                            delete a.pagination.type)),
                    !0 === a.loop && (a.loopedSlides = this.getSlidesCount()),
                    s ? "fade" === a.effect && (a.fadeEffect = {
                        crossFade: !0
                    }) : a.slidesPerGroup = +e.slides_to_scroll || 1,
                    "coverflow" == a.effect ? a.coverflowEffect = {
                        rotate: 50,
                        stretch: 0,
                        depth: 100,
                        modifier: 1,
                        slideShadows: !0
                    } : "creative" == a.effect ? a.creativeEffect = {
                        prev: {
                            shadow: !0,
                            translate: [0, 0, -400]
                        },
                        next: {
                            translate: ["100%", 0, 0]
                        }
                    } : "creative2" == a.effect ? (a.effect = "creative",
                        a.creativeEffect = {
                            perspective: !0,
                            limitProgress: 2,
                            shadowPerProgress: !0,
                            prev: {
                                shadow: !0,
                                translate: ["-10%", 0, -200],
                                rotate: [0, 0, -2]
                            },
                            next: {
                                shadow: !1,
                                translate: ["120%", 0, 0]
                            }
                        }) : "creative3" == a.effect ? (a.effect = "creative",
                            a.creativeEffect = {
                                prev: {
                                    shadow: !0,
                                    translate: ["-125%", 0, -800],
                                    rotate: [0, 0, -90]
                                },
                                next: {
                                    shadow: !0,
                                    translate: ["125%", 0, -800],
                                    rotate: [0, 0, 90]
                                }
                            }) : "creative4" == a.effect ? (a.effect = "creative",
                                a.creativeEffect = {
                                    prev: {
                                        shadow: !0,
                                        origin: "left center",
                                        translate: ["-5%", 0, -200],
                                        rotate: [0, 100, 0]
                                    },
                                    next: {
                                        origin: "right center",
                                        translate: ["5%", 0, -200],
                                        rotate: [0, -100, 0]
                                    }
                                }) : "cube" == a.effect ? a.cubeEffect = {
                                    shadow: !0,
                                    slideShadows: !0,
                                    shadowOffset: 20,
                                    shadowScale: .94
                                } : "coverflow2" == a.effect && (a.effect = "coverflow",
                                    a.coverflowEffect = {
                                        rotate: 0,
                                        stretch: 0,
                                        depth: 100,
                                        modifier: 3,
                                        slideShadows: !0
                                    }),
                    a
            }

            alpusFlexbox.SlidesHandler.prototype.initSlider = async function () {
                const e = this.elements.$swiperContainer;
                var timers = [];
                if (!e.length)
                    return;
                if (1 >= this.getSlidesCount())
                    return;
                const t = elementorFrontend.utils.swiper;
                var s = this.getSwiperOptions();
                this.swiper = await new t(e, s),
                    e.data("swiper", this.swiper),
                    this.handleKenBurns();
                const i = this.getElementSettings();
                "creative2" == i.transition && this.elements.$swiperContainer.css("overflow", "visible"),
                    i.pause_on_hover && this.togglePauseOnHover(!0);
                const n = this.getSettings()
                    , a = e.data(n.attributes.dataAnimation);

                var wrapper = e.children('.swiper-wrapper'),
                    cls = wrapper.attr('class');
                var pattern = /gutter\-\w\w|cols\-\d|cols\-\w\w-\d|cols\-\w\w\w-\d/g;
                var match = cls.match(pattern) || '';
                if (match) {
                    match.push('row');
                    wrapper.data('swiper-layout', match);
                    wrapper.attr('class', cls.replace(pattern, '').replace(/\s+/, ' ')).removeClass('row');
                }

                if ($.fn.lazyload && typeof theme.defaults.lazyload != 'undefined') {
                    wrapper.find('[data-lazy]')
                        .filter(function () {
                            return !$(this).data('_lazyload_init');
                        })
                        .data('_lazyload_init', 1)
                        .each(function () {
                            $(this).lazyload(theme.defaults.lazyload);
                        });
                }

                // If slider has animated items
                var $anim_items = e.find('.elementor-invisible, .appear-animate, .animated').filter(':not(.elementor-column)');
                if ($anim_items.length) {
                    e.addClass('animation-slider');
                    $anim_items.addClass('slide-animate').each(function () {
                        var $this = $(this);
                        var pre = $this.data('settings');
                        if (pre) {
                            var settings = {
                                '_animation': pre._animation ? pre._animation : pre.animation
                            };
                            if (pre._animation_delay) {
                                settings['_animation_delay'] = Number(pre._animation_delay);
                            }
                            $this
                                .data('settings', settings)
                                .attr('data-settings', JSON.stringify(settings));
                        }
                    });
                }

                // carousel content animation
                e.find('.swiper-slide-active .slide-animate').each(function () {
                    var $animation_item = $(this),
                        duration;

                    if ($animation_item.hasClass('animated-slow')) {
                        duration = 2000;
                    } else if ($animation_item.hasClass('animated-fast')) {
                        duration = 750;
                    } else {
                        duration = 1000;
                    }

                    $animation_item.css('animation-duration', duration + 'ms');

                    duration = duration ? duration : 750;
                });

                var $activeSlider = $(this.swiper.slides).slice(this.swiper.activeIndex, this.swiper.activeIndex + this.swiper.params.slidesPerView),
                    $slideAnimations = $activeSlider.find('.slide-animate');
                e.find('.swiper-slide .slide-animate').each(function () {
                    if ($slideAnimations.index($(this)) >= 0) return;

                    var $animation_item = $(this),
                        settings = 'undefined' != typeof $animation_item.data('settings') ? $animation_item.data('settings') : {},
                        duration,
                        delay = settings._animation_delay ? settings._animation_delay : 0;

                    var animation = '';
                    if ('undefined' != typeof settings._animation) {
                        animation = settings._animation;
                    } else if ('undefined' != typeof settings.animation) {
                        animation = settings.animation;
                    } else if ('undefined' != typeof $animation_item.data('rocket-animation')) {
                        animation = $animation_item.data('rocket-animation');
                        if ('undefined' != typeof settings._animation_delay) {
                            settings._animation = animation;
                        } else {
                            settings.animation = animation;
                        }

                        $animation_item.data('settings', settings);
                    }

                    if ($animation_item.hasClass('animated-slow')) {
                        duration = 2000;
                    } else if ($animation_item.hasClass('animated-fast')) {
                        duration = 750;
                    } else {
                        duration = 1000;
                    }

                    $animation_item.css('animation-duration', duration + 'ms');

                    duration = duration ? duration : 750;

                    var temp = theme.requestTimeout(function () {
                        $animation_item.removeClass(animation + ' animated');
                        timers.splice(timers.indexOf(temp), 1)
                    }, delay + duration);
                });

                this.swiper.on("slideResetTransitionEnd", function () {
                    e.find('.swiper-slide .show-content').removeClass('show-content animated');

                    var $activeSlider = $(this.slides).slice(this.activeIndex, this.activeIndex + this.params.slidesPerView),
                        $slideAnimations = $activeSlider.find('.slide-animate');

                    $slideAnimations.addClass('show-content');
                })

                this.swiper.on("slideChangeTransitionStart", function () {
                    if (a) {
                        e.find(n.selectors.slideInnerContents).removeClass(n.classes.animated + " " + a).hide()
                    }
                })

                this.swiper.on("slideChangeTransitionEnd", function () {
                    if (a) {
                        e.find(n.selectors.slideInnerContents).show().addClass(n.classes.animated + " " + a)
                    }

                    e.find('.swiper-slide .show-content').removeClass('show-content animated');

                    var $activeSlider = $(this.slides).slice(this.activeIndex, this.activeIndex + this.params.slidesPerView),
                        $slideAnimations = $activeSlider.find('.slide-animate');

                    /* clear all animations that are running. */
                    if (e.hasClass("animation-slider")) {
                        for (var i = 0; i < timers.length; i++) {
                            theme.deleteTimeout(timers[i]);
                        }
                        timers = [];
                    }

                    $slideAnimations.each(function () {
                        var $animation_item = $(this),
                            settings = 'undefined' != typeof $animation_item.data('settings') ? $animation_item.data('settings') : {},
                            duration,
                            delay = settings._animation_delay ? settings._animation_delay : 0,
                            aniName = settings._animation;

                        if ($animation_item.hasClass('animated')) return;

                        if ($animation_item.hasClass('animated-slow')) {
                            duration = 2000;
                        } else if ($animation_item.hasClass('animated-fast')) {
                            duration = 750;
                        } else {
                            duration = 1000;
                        }

                        $animation_item.css({
                            'animation-duration': duration + 'ms',
                            'animation-delay': delay + 'ms',
                            'transition-property': 'visibility, opacity',
                            'transition-duration': duration + 'ms',
                            'transition-delay': delay + 'ms',
                        }).addClass(aniName);

                        if ($animation_item.hasClass('maskLeft')) {
                            $animation_item.css('width', 'fit-content');
                            var width = $animation_item.width();
                            $animation_item
                                .css('width', 0)
                                .css('transition', 'width ' + (duration ? duration : 750) + 'ms linear ' + (delay ? delay : '0s'))
                                .css('width', width);
                        }


                        duration = duration ? duration : 750;
                        $animation_item.addClass('show-content');

                        var temp = theme.requestTimeout(function () {
                            $animation_item.css('transition-property', '');
                            $animation_item.css('transition-delay', '');
                            $animation_item.css('transition-duration', '');

                            timers.splice(timers.indexOf(temp), 1)
                        }, (delay ? (delay + 200) : 200));
                        timers.push(temp);
                    });

                    e.find('.swiper-slide .slide-animate').each(function () {
                        var $animation_item = $(this),
                            settings = 'undefined' != typeof $animation_item.data('settings') ? $animation_item.data('settings') : {};

                        if ($slideAnimations.index($(this)) < 0 && settings) {
                            var animation = '';
                            if ('undefined' != typeof settings._animation) {
                                animation = settings._animation;
                            } else if ('undefined' != typeof settings.animation) {
                                animation = settings.animation;
                            } else if ('undefined' != typeof $animation_item.data('rocket-animation')) {
                                animation = $animation_item.data('rocket-animation');
                                if ('undefined' != typeof settings._animation_delay) {
                                    settings._animation = animation;
                                } else {
                                    settings.animation = animation;
                                }

                                $animation_item.data('settings', settings);
                            }

                            $animation_item.removeClass(animation + ' animated appear-animation-visible elementor-invisible appear-animate');
                        }
                    });

                    if (this.activeIndex == this.params.slidesPerView - 1) {
                        this.emit('alpusflexbox.from.begin');
                    }
                })

                this.swiper.on('fromEdge alpusflexbox.from.begin', function () {

                    if (!this.params.loop) return;

                    const slidesPerView = this.params.slidesPerView;
                    var $activeSlides, $slideAnimations;

                    if (this.activeIndex > slidesPerView - 1) {
                        $activeSlides = $(this.slides).slice(slidesPerView + 1, slidesPerView * 2);
                        $slideAnimations = $activeSlides.find('.slide-animate');
                    } else {
                        $activeSlides = $(this.slides).slice(- slidesPerView - 1, -1);
                        $slideAnimations = $activeSlides.find('.slide-animate');
                    }

                    $slideAnimations.each(function () {
                        var $animation_item = $(this),
                            settings = 'undefined' != typeof $animation_item.data('settings') ? $animation_item.data('settings') : {};

                        if (settings && !$animation_item.hasClass('show-content')) {
                            $animation_item.addClass('show-content animated');
                        }
                    })
                });
                this.swiper.on('resize', function () {
                    if (e.hasClass('animation-slider')) {
                        e.find('.slider-slide-active .slide-animate').each(function () {
                            $(this)
                                .addClass('show-content')
                                .css({
                                    'animation-name': '',
                                    'animation-duration': '',
                                    'animation-delay': '',
                                });
                        });
                    }
                });
            }
        }

    });
})(jQuery);