/**
 * Alpha Text Hover Image Library
 * 
 * @package    WP Alpha Core FrameWork
 * @subpackage Core
 * @author     D-THEMES
 * @since      1.0
 */

'use strict';

window.theme = window.theme || {};

(function ($) {

    theme.textHoverImage = function (selector) {
        var text = theme.$(selector).get(0);
        text.addEventListener('mousemove', (function (e) {
            setInterval(function (e, obj) {
                var offset = obj.getBoundingClientRect(),
                    xValue = e.clientX - offset.x,
                    yValue = e.clientY - offset.y;
                $(obj).find('.hover-image').get(0).style.transform = 'translate('.concat(xValue, 'px, ').concat(yValue, 'px)')
            }(e, text), 1000)
        }))
    }

    if (window.theme && theme.status == 'complete') {
        $('.text-hover-image').each(function () {
            theme.textHoverImage(this);
        })
    } else {
        $(window).on('alpha_complete', function () {
            $('.text-hover-image').each(function () {
                theme.textHoverImage(this);
            })
        });
    }
})(jQuery);