<?php
/**
 * Alpha Text Hover Image widget
 *
 * @author     Andon
 * @package    Alpha Core FrameWork
 * @subpackage Core
 * @since      4.4.0
 */

// direct load is not allowed
defined( 'ABSPATH' ) || die;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

class Alpha_Text_Hover_Image_Elementor_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return ALPHA_NAME . '_widget_text_hover_image';
	}

	public function get_title() {
		return esc_html__( 'Text Hover Image', 'alpha-core' );
	}

	public function get_categories() {
		return array( 'alpha_widget' );
	}

	public function get_icon() {
		return 'alpha-elementor-widget-icon eicon-image-rollover';
	}

	protected function is_dynamic_content(): bool {
		return false;
	}

	public function get_style_depends() {
		return array( 'alpha-text-hover-image' );
	}

	public function get_script_depends() {
		return array( 'alpha-text-hover-image' );
	}

	public function has_widget_inner_wrapper(): bool {
		return ! Plugin::$instance->experiments->is_feature_active( 'e_optimized_markup' );
	}

	protected function register_controls() {

		$left  = is_rtl() ? 'right' : 'left';
		$right = 'left' == $left ? 'right' : 'left';

		$this->start_controls_section(
			'section_content',
			array(
				'label' => esc_html__( 'Content', 'alpha-core' ),
			)
		);

			$this->add_control(
				'before_hover_text',
				array(
					'label'       => esc_html__( 'Before Hover Text', 'alpha-core' ),
					'type'        => Controls_Manager::TEXT,
					'ai'          => array(
						'type' => 'text',
					),
					'dynamic'     => array(
						'active' => true,
					),
					'placeholder' => esc_html__( 'Enter before text', 'alpha-core' ),
				)
			);

			$this->add_control(
				'hover_text',
				array(
					'label'       => esc_html__( 'Hover Text', 'alpha-core' ),
					'type'        => Controls_Manager::TEXT,
					'ai'          => array(
						'type' => 'text',
					),
					'dynamic'     => array(
						'active' => true,
					),
					'placeholder' => esc_html__( 'Enter hover text', 'alpha-core' ),
					'default'     => esc_html__( 'Hover Here', 'alpha-core' ),
				)
			);

			$this->add_control(
				'after_hover_text',
				array(
					'label'       => esc_html__( 'After Hover Text', 'alpha-core' ),
					'type'        => Controls_Manager::TEXT,
					'ai'          => array(
						'type' => 'text',
					),
					'dynamic'     => array(
						'active' => true,
					),
					'placeholder' => esc_html__( 'Enter after text', 'alpha-core' ),
				)
			);

			$this->add_control(
				'image',
				array(
					'label'   => esc_html__( 'Hover Image', 'alpha-core' ),
					'type'    => Controls_Manager::MEDIA,
					'dynamic' => array(
						'active' => true,
					),
				)
			);

			$this->add_control(
				'html_tag',
				array(
					'label'   => esc_html__( 'HTML Tag', 'alpha-core' ),
					'type'    => Controls_Manager::SELECT,
					'options' => array(
						'h1'  => 'H1',
						'h2'  => 'H2',
						'h3'  => 'H3',
						'h4'  => 'H4',
						'h5'  => 'H5',
						'h6'  => 'H6',
						'div' => 'div',
						'p'   => 'p',
					),
					'default' => 'h2',
				)
			);

			$this->add_control(
				'link',
				array(
					'label'     => esc_html__( 'Link', 'alpha-core' ),
					'type'      => Controls_Manager::URL,
					'dynamic'   => array(
						'active' => true,
					),
					'default'   => array(
						'url' => '',
					),
					'separator' => 'before',
				)
			);

			$this->add_responsive_control(
				'align',
				array(
					'label'     => esc_html__( 'Alignment', 'alpha-core' ),
					'type'      => Controls_Manager::CHOOSE,
					'options'   => array(
						'left'    => array(
							'title' => esc_html__( 'Left', 'alpha-core' ),
							'icon'  => 'eicon-text-align-left',
						),
						'center'  => array(
							'title' => esc_html__( 'Center', 'alpha-core' ),
							'icon'  => 'eicon-text-align-center',
						),
						'right'   => array(
							'title' => esc_html__( 'Right', 'alpha-core' ),
							'icon'  => 'eicon-text-align-right',
						),
						'justify' => array(
							'title' => esc_html__( 'Justified', 'alpha-core' ),
							'icon'  => 'eicon-text-align-justify',
						),
					),
					'default'   => '',
					'separator' => 'before',
					'selectors' => array(
						'.elementor-element-{{ID}} .text-hover-image-wrapper' => 'text-align: {{VALUE}};',
					),
				)
			);
		$this->end_controls_section(); // Content Section End

		$this->start_controls_section(
			'section_style',
			array(
				'label' => esc_html__( 'Text', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_control(
				'title_color',
				array(
					'label'     => esc_html__( 'Text Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .title' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_control(
				'title_hover_color',
				array(
					'label'     => esc_html__( 'Hover Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .title:hover' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'typography',
					'selector' => '.elementor-element-{{ID}} .title',
				)
			);

			$this->add_control(
				'heading_hover_text',
				array(
					'label'     => esc_html__( 'Hover Text', 'alpha-core' ),
					'type'      => Controls_Manager::HEADING,
					'separator' => 'before',
				)
			);

			$this->add_control(
				'hover_text_color',
				array(
					'label'     => esc_html__( 'Text Color', 'alpha-core' ),
					'type'      => Controls_Manager::COLOR,
					'selectors' => array(
						'.elementor-element-{{ID}} .text-hover-image' => 'color: {{VALUE}};',
					),
				)
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				array(
					'name'     => 'hover_typography',
					'selector' => '.elementor-element-{{ID}} .text-hover-image',
				)
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_image_style',
			array(
				'label' => esc_html__( 'Image', 'alpha-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

			$this->add_responsive_control(
				'image_width',
				array(
					'label'      => esc_html__( 'Width', 'alpha-core' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', '%', 'em', 'rem' ),
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .hover-image' => 'width: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->add_responsive_control(
				'image_height',
				array(
					'label'      => esc_html__( 'Height', 'alpha-core' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', '%', 'em', 'rem' ),
					'separator'  => 'after',
					'range'      => array(
						'px' => array(
							'min' => 0,
							'max' => 1000,
						),
						'%'  => array(
							'min' => 0,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .hover-image img' => 'height: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->add_responsive_control(
				'image_position_top',
				array(
					'label'      => esc_html__( 'Position Vertical', 'alpha-core' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => -1000,
							'max' => 1000,
						),
						'%'  => array(
							'min' => -100,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .hover-image' => 'top: {{SIZE}}{{UNIT}};',
					),
				)
			);

			$this->add_responsive_control(
				'image_position_left',
				array(
					'label'      => esc_html__( 'Position Horizontal', 'alpha-core' ),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => array( 'px', '%' ),
					'range'      => array(
						'px' => array(
							'min' => - 1000,
							'max' => 1000,
						),
						'%'  => array(
							'min' => - 100,
							'max' => 100,
						),
					),
					'selectors'  => array(
						'.elementor-element-{{ID}} .hover-image' => "{$left}: {{SIZE}}{{UNIT}};",
					),
				)
			);

		$this->end_controls_section();

	}

	protected function render() {
		$atts = $this->get_settings_for_display();
		require alpha_core_e_templates_path( 'widgets/text-hover-image/render-text-hover-image-elementor' );
	}
}
