/**
 * Alpha Isotopes Js Library
 * 
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      4.14.0
 */
'use strict';

window.theme || (window.theme = {});

(function ($) {

    theme.defaults || (theme.defaults = {});

    theme.defaults.isotope = {
        itemSelector: '.grid-item',
        layoutMode: 'masonry',
        percentPosition: true,
        masonry: {
            columnWidth: '.grid-space'
        },
        // getSortData: {
        //     order: '[data-creative-order] parseInt',
        //     order_xxl: '[data-creative-order-xxl] parseInt',
        //     order_xlg: '[data-creative-order-xlg] parseInt',
        //     order_xl: '[data-creative-order-xl] parseInt',
        //     order_lg: '[data-creative-order-lg] parseInt',
        //     order_md: '[data-creative-order-md] parseInt',
        //     order_sm: '[data-creative-order-sm] parseInt',
        // },
        getSortData: {
            order: '[data-creative-order] parseInt',
            order_lg: '[data-creative-order-lg] parseInt',
            order_md: '[data-creative-order-md] parseInt',
        },
    }

    /**
     * Run isotopes
     *
     * @since 1.0
     * @param {string} selector
     * @param {Object} options
     * @return {void}
     */
    theme.isotopes = (function () {
        function parseOptions(options) {
            return 'string' == typeof options ? JSON.parse(options.replace(/'/g, '"').replace(';', '')) : {};
        }

        function _isotopeSort(e, $selector) {
            var $grid = $selector ? $selector : $('.grid');

            if (!$grid.length) {
                return;
            }

            $grid.each(function (e) {
                var $this = $(this);
                if (!$this.attr('data-creative-breaks') || $this.hasClass('float-grid')) {
                    return;
                }

                $this.children('.grid-item').css({ 'animation-fill-mode': 'none', '-webkit-animation-fill-mode': 'none' });

                var width = window.innerWidth,
                    breaks = JSON.parse($this.attr('data-creative-breaks')),
                    cur_break = $this.attr('data-current-break');

                // if (width >= breaks['xlg']) {
                //     width = '';
                // } else if (width >= breaks['xlg'] && width < breaks['xxl']) {
                //     width = 'xxl';
                // } else if (width >= breaks['xl'] && width < breaks['xlg']) {
                //     width = 'xlg';
                // } else if (width >= breaks['lg'] && width < breaks['xl']) {
                //     width = 'xl';
                // } else if (width >= breaks['md'] && width < breaks['lg']) {
                //     width = 'lg';
                // } else if (width >= breaks['sm'] && width < breaks['md']) {
                //     width = 'md';
                // } else if (width < breaks['sm']) {
                //     width = 'sm';
                // }

                if (width >= breaks['lg']) {
                    width = '';
                } else if (width >= breaks['md'] && width < breaks['lg']) {
                    width = 'lg';
                } else if (width < breaks['md']) {
                    width = 'md';
                }

                if (width == cur_break) {
                    return;
                }

                if ($this.data('isotope')) {
                    $this.isotope({
                        sortBy: 'order' + (width ? '_' + width : ''),
                    }).isotope('layout');
                } else {
                    var options = parseOptions($this.attr('data-grid-options'));
                    options.sortBy = 'order' + (width ? '_' + width : '');
                    $this.attr('data-grid-options', JSON.stringify(options));
                }
                $this.attr('data-current-break', width);
            });
        }

        return function ($selector, options) {
            if (!$.fn.imagesLoaded || !$.fn.isotope) {
                return;
            }
            $selector.each(function () {
                var $this = $(this);
                if ($this.hasClass('grid-float')) {
                    return;
                }

                var settings = $.extend(true, {},
                    theme.defaults.isotope,
                    parseOptions(this.getAttribute('data-grid-options')),
                    options ? options : {},
                    $this.hasClass('masonry') ? { horizontalOrder: true } : {}
                );

                _isotopeSort('', $this);

                if (settings.masonry.columnWidth && !$this.children(settings.masonry.columnWidth).length) {
                    delete settings.masonry.columnWidth;
                }

                Object.setPrototypeOf(this, HTMLElement.prototype);
                $this.children().each(function () {
                    Object.setPrototypeOf(this, HTMLElement.prototype);
                });

                if ($this.attr('data-creative-breaks')) {
                    var width = window.innerWidth,
                        breaks = JSON.parse($this.attr('data-creative-breaks'));

                    // if (width >= breaks['xlg']) {
                    //     width = '';
                    // } else if (width >= breaks['xlg'] && width < breaks['xxl']) {
                    //     width = 'xxl';
                    // } else if (width >= breaks['xl'] && width < breaks['xlg']) {
                    //     width = 'xlg';
                    // } else if (width >= breaks['lg'] && width < breaks['xl']) {
                    //     width = 'xl';
                    // } else if (width >= breaks['md'] && width < breaks['lg']) {
                    //     width = 'lg';
                    // } else if (width >= breaks['sm'] && width < breaks['md']) {
                    //     width = 'md';
                    // } else if (width < breaks['sm']) {
                    //     width = 'sm';
                    // }

                    if (width >= breaks['lg']) {
                        width = '';
                    } else if (width >= breaks['md'] && width < breaks['lg']) {
                        width = 'lg';
                    } else if (width < breaks['md']) {
                        width = 'md';
                    }

                    $.extend(settings, {
                        sortBy: 'order' + (width ? '_' + width : ''),
                    });
                }
                $this.imagesLoaded(function () {
                    $this.addClass('isotope-loaded').isotope(settings);
                    'undefined' != typeof elementorFrontend && $this.trigger('resize.waypoints');
                });
            });

            $(window).on('resize', _isotopeSort);
        }
    })();

    $(document.body).on('alpha_init_tab_template', function (e, $template) {
        theme.isotopes($template.find('.grid'));
    })
    if (window.theme && typeof theme.status == 'undefined') {
        theme.isotopes($('.grid:not(.lp-courses-bar)'));   // Masonry Layout
    } else {
        $(window).on('alpha_complete', function () {
            theme.isotopes($('.grid:not(.lp-courses-bar)'));   // Masonry Layout
        });
    }
})(jQuery);