/**
 * Alpha Sticky Content JS Library
 * 
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      4.14..0
 */
'use strict';

window.theme || (window.theme = {});

(function ($) {

    theme.defaults || (theme.defaults = {});

    theme.defaults.stickyMobileBar = {
        minWidth: 0,
        maxWidth: 767,
        top: 150,
        wrapperClass: 'mobile-icon-bar-wrapper',
        // hide: true,
    };
    theme.defaults.stickyToolbox = {
        minWidth: 0,
        maxWidth: 767,
    };
    theme.defaults.sticky = {
        minWidth: 0,
        maxWidth: 20000,
        top: false,
        bottomOrigin: false,
        // hide: false, // hide when it is not sticky.
        max_index: 1039, // maximum z-index of sticky contents
    };


    /**
     * Check if window's width is really resized.
     * 
     * @since 1.0
     * @param {number} timeStamp
     * @return {boolean}
     */
    theme.windowResized = function (timeStamp) {
        if (timeStamp == theme.resizeTimeStamp) {
            return theme.resizeChanged;
        }
        theme.resizeChanged = theme.canvasWidth != window.innerWidth;
        theme.canvasWidth = window.innerWidth;
        theme.resizeTimeStamp = timeStamp;
        return theme.resizeChanged;
    }

    theme.stickyContent = (function () {
        function StickyContent($el, options) {
            return this.init($el, options);
        }

        function refreshAll() {
            $(window).trigger('sticky_refresh.alpha', {
                index: 0,
                offsetTop: window.innerWidth > 600 && $('#wp-toolbar').length && $('#wp-toolbar').parent().is(':visible') ? $('#wp-toolbar').parent().outerHeight() : 0
            });
        }

        function refreshAllSize(e) {
            if (!e || theme.windowResized(e.timeStamp)) {
                $(window).trigger('sticky_refresh_size.alpha');
                theme.requestFrame(refreshAll);
            }
        }

        StickyContent.prototype.init = function ($el, options) {
            // Disable in elementor pro template
            if ($el.closest('.elementor-add-to-cart').length) {
                return;
            }

            // Init
            this.$el = $el;
            this.options = $.extend(true, {}, theme.defaults.sticky, options, ($el.attr('data-sticky-options') ? JSON.parse($el.attr('data-sticky-options').replace(/'/g, '"').replace(';', '')) : {}));
            this.scrollPos = window.pageYOffset; // issue: heavy js performance : 30.7ms
            this.originalHeight = this.$el.outerHeight();
            $(window)
                .on('sticky_refresh.alpha', this.refresh.bind(this))
                .on('sticky_refresh_size.alpha', this.refreshSize.bind(this));
        }

        StickyContent.prototype.destroy = function () {
            this.unwrap();
            this.$el.removeClass('sticky-content fix-top fixed');
            this.$el.removeData('sticky-content');
            this.$el = $('#alpha-null');
        }

        StickyContent.prototype.refreshSize = function (e) {
            if (typeof this.$el.data('sticky-content') == 'undefined') {
                return;
            }

            var beWrap = window.innerWidth >= this.options.minWidth && window.innerWidth <= this.options.maxWidth;
            if (typeof this.top == 'undefined') {
                this.top = this.options.top;
            }

            if (window.innerWidth >= 768 && this.getTop) {
                this.top = this.getTop();
            } else if (!this.options.top) {
                this.top = this.isWrap ?
                    this.$el.parent().offset().top :
                    this.$el.offset().top + this.$el[0].offsetHeight;

                // if sticky header has toggle dropdown menu, increase top
                if (this.$el.find('.toggle-menu.show-home').length) {
                    this.top += this.$el.find('.toggle-menu .dropdown-box')[0].offsetHeight;
                }
            }

            if (!this.isWrap) {
                beWrap && this.wrap();
            } else {
                beWrap || this.unwrap();
            }

            if (this.$el.is(':hidden')) {
                this.unwrap();
            }
            e && theme.requestTimeout(this.refreshSize.bind(this), 50);
        }

        StickyContent.prototype.wrap = function () {
            this.$el.wrap('<div class="sticky-content-wrapper' + (typeof this.options.wrapperClass != 'undefined' && this.options.wrapperClass ? (' ' + this.options.wrapperClass) : '') + '"></div>');
            this.$el.addClass('wrapped');
            this.$el.closest('.toolbox-horizontal').addClass('horizontal-fixed');
            this.isWrap = true;
        }

        StickyContent.prototype.unwrap = function () {
            this.$el.unwrap('.sticky-content-wrapper');
            this.$el.removeClass('wrapped');
            this.$el.closest('.toolbox-horizontal').removeClass('horizontal-fixed');
            this.isWrap = false;
        }

        StickyContent.prototype.onFixed = function (self) {
            $(window).trigger('alpha_on_fixed', [self]);
        }

        StickyContent.prototype.onUnfixed = function (self) {
            $(window).trigger('alpha_on_unfixed', [self]);
        }

        StickyContent.prototype.refresh = function (e, data) {
            var pageYOffset = window.pageYOffset /* + data.offsetTop*/; // issue: heavy js performance, 6.7ms
            var $el = this.$el;

            this.refreshSize();
            $('.fixed.fix-top').each(function () {
                pageYOffset += $(this).outerHeight();
            });

            // For side header
            var needUnFixed = false;
            if ($('body').hasClass('side-header')) {
                if (($('body').hasClass('side-on-desktop') && window.innerWidth > 991) ||
                    ($('body').hasClass('side-on-tablet') && window.innerWidth > 767) ||
                    ($('body').hasClass('side-on-mobile') && window.innerWidth > 575) ||
                    (!$('body').hasClass('side-on-desktop') && !$('body').hasClass('side-on-tablet') && !$('body').hasClass('side-on-mobile'))) {
                    if (this.$el.closest('.header-area').length) {
                        needUnFixed = true;
                    }
                }
            }

            var minHeightOffset = $el.outerHeight();
            if ($el.hasClass('fix-bottom')) {
                if (minHeightOffset > $el.parent().outerHeight()) {
                    minHeightOffset = $el.parent().outerHeight();
                }
            }

            // Has animation
            if ($el.attr('data-settings')) {
                var settings = JSON.parse($el.attr('data-settings')),
                    animationClass = '';
                if ('undefined' != typeof settings._animation) {
                    animationClass = settings._animation;
                } else if ('undefined' != typeof settings.animation) {
                    animationClass = settings.animation;
                } else if ('undefined' != typeof $el.data('rocket-animation')) {
                    animationClass = $el.data('rocket-animation');
                }
            }

            // Make sticky
            if (!needUnFixed && (pageYOffset > this.top + minHeightOffset) && this.isWrap) {

                // calculate height
                this.height = $el[0].offsetHeight;
                $el.hasClass('sticky-content-transparent') || $el.hasClass('fixed') || $el.parent().css('height', this.height + 'px');

                // update sticky status
                if (this.options.scrollMode || (typeof this.options.scrollMode == 'undefined' && $('body').hasClass('smart-sticky'))) {
                    if ((this.scrollPos > window.pageYOffset && $el.hasClass('fix-top') && (!$el.hasClass('fixed') || $el.hasClass('fixed-hide'))) ||
                        (this.scrollPos < window.pageYOffset && $el.hasClass('fix-bottom') && (!$el.hasClass('fixed') || $el.hasClass('fixed-hide'))) ||
                        (this.scrollPos + window.innerHeight > $(document).height() - 50 && $el.closest('.header').length && $el.hasClass('fix-top') && (!$el.hasClass('fixed') || $el.hasClass('fixed-hide')))) {
                        $el.removeClass('fixed-hide').addClass('fixed');
                        if (typeof animationClass != 'undefined' && $el.hasClass(animationClass)) {
                            $el.removeClass(animationClass);
                        }
                        if ($el.hasClass('fix-top')) {
                            var height = parseFloat($('body').css('--alpha-top-sticky-h').slice(0, -2));
                            $('body').css('--alpha-top-sticky-h', height + parseFloat($el.outerHeight()) + 'px');
                        } else {
                            $el.css('transition', '');
                            var height = parseFloat($('body').css('--alpha-bottom-sticky-h').slice(0, -2)),
                                elHeight = parseFloat($el.outerHeight());
                            if ($('.cookies-popup.show').length) {
                                var cookieHeight = $('.cookies-popup.show').outerHeight() + 20;
                                if (elHeight > cookieHeight) {
                                    $('body').css('--alpha-bottom-sticky-h', height - cookieHeight + elHeight + 'px');
                                }
                            } else {
                                $('body').css('--alpha-bottom-sticky-h', height + elHeight + 'px');
                            }
                        }
                        this.onFixed && this.onFixed(this);
                    } else if ((this.scrollPos < window.pageYOffset && $el.hasClass('fix-top') && ($el.hasClass('fixed') && !$el.hasClass('fixed-hide'))) ||
                        (this.scrollPos > window.pageYOffset && $el.hasClass('fix-bottom') && ($el.hasClass('fixed')) && !$el.hasClass('fixed-hide'))) {
                        if ((this.scrollPos + window.innerHeight >= $(document).height() - 50 && $el.closest('.header').length && $el.hasClass('fix-top'))) {
                            // If sticky header reaches bottom of screen ignore
                        } else {
                            if ($el.hasClass('fix-top')) {
                                var height = parseFloat($('body').css('--alpha-top-sticky-h').slice(0, -2));
                                $('body').css('--alpha-top-sticky-h', height - parseFloat($el.outerHeight()) + 'px');
                            } else {
                                var height = parseFloat($('body').css('--alpha-bottom-sticky-h').slice(0, -2)),
                                    elHeight = parseFloat($el.outerHeight());
                                if ($('.cookies-popup.show').length) {
                                    var cookieHeight = $('.cookies-popup.show').outerHeight() + 20;
                                    if (elHeight > cookieHeight) {
                                        $('body').css('--alpha-bottom-sticky-h', height - elHeight + cookieHeight + 'px');
                                    }
                                } else {
                                    $('body').css('--alpha-bottom-sticky-h', height - elHeight + 'px');
                                }
                            }
                            $el.addClass('fixed-hide').css({ 'margin-top': '', 'margin-bottom': '', 'z-index': '' });
                            this.onUnfixed && this.onUnfixed(this);
                        }
                    }
                    this.scrollPos = window.pageYOffset;
                } else {
                    if (!$el.hasClass('fixed')) {
                        $el.addClass('fixed');
                        if (typeof animationClass != 'undefined' && $el.hasClass(animationClass)) {
                            $el.removeClass(animationClass);
                        }
                        if ($el.hasClass('fix-top')) {
                            var height = parseFloat($('body').css('--alpha-top-sticky-h').slice(0, -2));
                            $('body').css('--alpha-top-sticky-h', height + parseFloat($el.outerHeight()) + 'px');
                        } else {
                            var height = parseFloat($('body').css('--alpha-bottom-sticky-h').slice(0, -2)),
                                elHeight = parseFloat($el.outerHeight());
                            if ($('.cookies-popup.show').length) {
                                var cookieHeight = $('.cookies-popup.show').outerHeight() + 20;
                                if (elHeight > cookieHeight) {
                                    $('body').css('--alpha-bottom-sticky-h', height - cookieHeight + elHeight + 'px');
                                }
                            } else {
                                $('body').css('--alpha-bottom-sticky-h', height + elHeight + 'px');
                            }
                        }
                        this.onFixed && this.onFixed(this);
                    }
                }

                // update sticky order
                if ($el.hasClass('fixed') && $el.hasClass('fix-top')) {
                    // this.zIndex = this.options.max_index - data.index;
                    this.zIndex = this.options.max_index - $('.fix-top').index($el);
                    $el.css({ 'margin-top': data.offsetTop + 'px', 'z-index': this.zIndex });
                } else if ($el.hasClass('fixed') && $el.hasClass('fix-bottom')) {
                    this.zIndex = this.options.max_index - data.index;
                    $el.css({ 'margin-bottom': data.offsetBottom + 'px', 'z-index': this.zIndex });
                } else {
                    if (this.options.scrollMode || (typeof this.options.scrollMode == 'undefined' && $('body').hasClass('smart-sticky'))) {
                        $el.css({ 'transition': 'opacity .3s, visibility .3s, transform .3s' });
                    } else {
                        $el.css({ 'transition': 'opacity .5s' });
                    }
                }

                // stack offset
                if ($el.hasClass('fixed')) {
                    if ($el.hasClass('fix-top')) {
                        data.offsetTop += $el[0].offsetHeight;
                    } else if ($el.hasClass('fix-bottom')) {
                        data.offsetBottom += $el[0].offsetHeight;
                    }
                }
            } else {
                if ($el.hasClass('fixed')) {
                    $el.parent().css('height', '');
                    if ($el.hasClass('fix-top')) {
                        if (!$el.hasClass('fixed-hide')) {
                            var height = parseFloat($('body').css('--alpha-top-sticky-h').slice(0, -2));
                            $('body').css('--alpha-top-sticky-h', height - parseFloat($el.outerHeight()) + 'px');
                        }
                    } else {
                        if (!$el.hasClass('fixed-hide')) {
                            var height = parseFloat($('body').css('--alpha-bottom-sticky-h').slice(0, -2)),
                                elHeight = parseFloat($el.outerHeight());
                            if ($('.cookies-popup.show').length) {
                                var cookieHeight = $('.cookies-popup.show').outerHeight() + 20;
                                if (elHeight > cookieHeight) {
                                    $('body').css('--alpha-bottom-sticky-h', height - elHeight + cookieHeight + 'px');
                                }
                            } else {
                                $('body').css('--alpha-bottom-sticky-h', height - elHeight + 'px');
                            }
                        } else {
                            $el.css('transition', 'none');
                        }
                    }
                    $el.removeClass('fixed').css({ 'margin-top': '', 'margin-bottom': '', 'z-index': '' });
                    if (typeof animationClass != 'undefined' && $el.hasClass(animationClass)) {
                        $el.removeClass(animationClass);
                    }
                    this.onUnfixed && this.onUnfixed(this);
                }
            }

            // For mobile sticky icon bar
            if (this.$el.hasClass('mobile-icon-bar')) {
                if (window.pageYOffset + window.innerHeight + 10 > $('body').find('.page-wrapper').offset().top + $('body').find('.page-wrapper').height()) {
                    if (!this.$el.hasClass('ending')) {
                        this.$el.addClass('ending');
                    }
                } else {
                    if (this.$el.hasClass('ending')) {
                        this.$el.removeClass('ending');
                    }
                }
            }

            $(window).trigger('alpha_finish_sticky');
        }

        window.addEventListener('scroll', refreshAll, { passive: true });
        $(window).on('resize', refreshAllSize);
        setTimeout(function () {
            refreshAllSize();
        }, 1000);

        return function (selector, options) {
            $(selector).each(function () {
                var $this = $(this);
                $this.data('sticky-content') || $this.data('sticky-content', new StickyContent($this, options));
            })
        }
    })()

    /**
     * Alpha Theme Setup
     */
    $(window).on('load', function () {
        theme.stickyContent('.sticky-content:not(.mobile-icon-bar):not(.sticky-toolbox)'); // Initialize sticky content
        theme.stickyContent('.mobile-icon-bar', theme.defaults.stickyMobileBar);		 // Initialize sticky mobile bar
        theme.stickyContent('.sticky-toolbox', theme.defaults.stickyToolbox);			 // Initialize sticky toolbox
    })
})(jQuery);