<?php
/**
 * The post default template
 *
 * @author     D-THEMES
 * @package    WP Alpha Framework
 * @subpackage Theme
 * @since      1.2.0
 */
defined( 'ABSPATH' ) || die;

$term = get_queried_object();

if ( $term && $term instanceof WP_Term ) {
	$extra_class = array();
	if ( ! empty( $anim_data['class'] ) ) {
		$extra_class[] = 'repeater-animate';
		$extra_class[] = $anim_data['class'];
	}

	if ( ! empty( $anim_data['data-settings'] ) ) {
		$item_anim_data                                      = $anim_data;
		$item_anim_data['data-settings']['_animation_delay'] = $anim_data['data-settings']['_animation_delay'] * ( $index + 1 );
	}
	?>

	<h3 class="term-title<?php echo ! $extra_class ? '' : ' ' . implode( ' ', $extra_class ); ?>"<?php echo ( isset( $item_anim_data['data-settings'] ) ? ' data-settings="' . esc_attr( json_encode( $item_anim_data['data-settings'] ) ) . '"' : '' ); ?>><a href="<?php echo esc_url( get_term_link( $term ) ); ?>"><?php echo esc_html( $term->name ); ?></a></h3>
}